/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.handler;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.SyncProgressHelper;
import com.android.ddmuilib.handler.BaseFileHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.widgets.Shell;

public class MethodProfilingHandler
extends BaseFileHandler
implements ClientData.IMethodProfilingHandler {
    public MethodProfilingHandler(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected String getDialogTitle() {
        return "Method Profiling Error";
    }

    public void onStartFailure(Client client, String message) {
        this.displayErrorInUiThread("Unable to create Method Profiling file for application '%1$s'\n\n%2$sCheck logcat for more information.", client.getClientData().getClientDescription(), message != null ? message + "\n\n" : "");
    }

    public void onEndFailure(Client client, String message) {
        this.displayErrorInUiThread("Unable to finish Method Profiling for application '%1$s'\n\n%2$sCheck logcat for more information.", client.getClientData().getClientDescription(), message != null ? message + "\n\n" : "");
    }

    public void onSuccess(final String remoteFilePath, final Client client) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (remoteFilePath == null) {
                    MethodProfilingHandler.this.displayErrorFromUiThread("Unable to download trace file: unknown file name.\nThis can happen if you disconnected the device while recording the trace.", new Object[0]);
                    return;
                }
                IDevice device = client.getDevice();
                try {
                    SyncService sync = client.getDevice().getSyncService();
                    if (sync != null) {
                        MethodProfilingHandler.this.pullAndOpen(sync, remoteFilePath);
                    } else {
                        MethodProfilingHandler.this.displayErrorFromUiThread("Unable to download trace file from device '%1$s'.", device.getSerialNumber());
                    }
                }
                catch (Exception e) {
                    MethodProfilingHandler.this.displayErrorFromUiThread("Unable to download trace file from device '%1$s'.", device.getSerialNumber());
                }
            }
        });
    }

    public void onSuccess(byte[] data, Client client) {
        try {
            File tempFile = this.saveTempFile(data, ".trace");
            this.open(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            String errorMsg = e.getMessage();
            this.displayErrorInUiThread("Failed to save trace data into temp file%1$s", errorMsg != null ? ":\n" + errorMsg : ".");
        }
    }

    private void pullAndOpen(final SyncService sync, final String remoteFilePath) throws InvocationTargetException, InterruptedException, IOException {
        File temp = File.createTempFile("android", ".trace");
        final String tempPath = temp.getAbsolutePath();
        try {
            SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                @Override
                public void run(SyncService.ISyncProgressMonitor monitor) throws SyncException, IOException, TimeoutException {
                    sync.pullFile(remoteFilePath, tempPath, monitor);
                }

                @Override
                public void close() {
                    sync.close();
                }
            }, String.format("Pulling %1$s from the device", remoteFilePath), this.mParentShell);
            this.open(tempPath);
        }
        catch (SyncException e) {
            if (!e.wasCanceled()) {
                this.displayErrorFromUiThread("Unable to download trace file:\n\n%1$s", e.getMessage());
            }
        }
        catch (TimeoutException e) {
            this.displayErrorFromUiThread("Unable to download trace file:\n\ntimeout", new Object[0]);
        }
    }

    protected void open(String tempPath) {
    }
}

