/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmuilib.heap.NativeLibraryAllocationInfo;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NativeHeapSnapshot {
    private static final NumberFormat NUMBER_FORMATTER = NumberFormat.getInstance();
    private List<NativeAllocationInfo> mHeapAllocations;
    private List<NativeLibraryAllocationInfo> mHeapAllocationsByLibrary;
    private List<NativeAllocationInfo> mNonZygoteHeapAllocations;
    private List<NativeLibraryAllocationInfo> mNonZygoteHeapAllocationsByLibrary;
    private long mTotalSize;

    public NativeHeapSnapshot(List<NativeAllocationInfo> heapAllocations) {
        this.mHeapAllocations = heapAllocations;
        this.mTotalSize = this.getTotalMemory(heapAllocations);
    }

    protected long getTotalMemory(Collection<NativeAllocationInfo> heapSnapshot) {
        long total = 0L;
        for (NativeAllocationInfo info : heapSnapshot) {
            total += (long)(info.getAllocationCount() * info.getSize());
        }
        return total;
    }

    public List<NativeAllocationInfo> getAllocations() {
        return this.mHeapAllocations;
    }

    public List<NativeLibraryAllocationInfo> getAllocationsByLibrary() {
        if (this.mHeapAllocationsByLibrary != null) {
            return this.mHeapAllocationsByLibrary;
        }
        List<NativeLibraryAllocationInfo> heapAllocations = NativeLibraryAllocationInfo.constructFrom(this.mHeapAllocations);
        if (this.isFullyResolved(heapAllocations)) {
            this.mHeapAllocationsByLibrary = heapAllocations;
        }
        return heapAllocations;
    }

    private boolean isFullyResolved(List<NativeLibraryAllocationInfo> heapAllocations) {
        for (NativeLibraryAllocationInfo info : heapAllocations) {
            if (!info.getLibraryName().equals("Resolving..")) continue;
            return false;
        }
        return true;
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public String getFormattedMemorySize() {
        return String.format("%s bytes", this.formatMemorySize(this.getTotalSize()));
    }

    protected String formatMemorySize(long memSize) {
        return NUMBER_FORMATTER.format(memSize);
    }

    public List<NativeAllocationInfo> getNonZygoteAllocations() {
        if (this.mNonZygoteHeapAllocations != null) {
            return this.mNonZygoteHeapAllocations;
        }
        this.mNonZygoteHeapAllocations = new ArrayList<NativeAllocationInfo>();
        for (NativeAllocationInfo info : this.mHeapAllocations) {
            if (!info.isZygoteChild()) continue;
            this.mNonZygoteHeapAllocations.add(info);
        }
        return this.mNonZygoteHeapAllocations;
    }

    public List<NativeLibraryAllocationInfo> getNonZygoteAllocationsByLibrary() {
        if (this.mNonZygoteHeapAllocationsByLibrary != null) {
            return this.mNonZygoteHeapAllocationsByLibrary;
        }
        List<NativeLibraryAllocationInfo> heapAllocations = NativeLibraryAllocationInfo.constructFrom(this.getNonZygoteAllocations());
        if (this.isFullyResolved(heapAllocations)) {
            this.mNonZygoteHeapAllocationsByLibrary = heapAllocations;
        }
        return heapAllocations;
    }
}

