/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.devicecommandhandlers;

import com.android.fakeadbserver.ClientState;
import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.devicecommandhandlers.DeviceCommandHandler;
import com.android.fakeadbserver.statechangehubs.ClientStateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.StateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.StateChangeQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class TrackJdwpCommandHandler
extends DeviceCommandHandler {
    public static final String COMMAND = "track-jdwp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke(FakeAdbServer fakeAdbServer, Socket responseSocket, DeviceState device, String args) {
        OutputStream stream;
        try {
            stream = responseSocket.getOutputStream();
        }
        catch (IOException e) {
            return false;
        }
        StateChangeQueue queue = device.getClientChangeHub().subscribe(new ClientStateChangeHandlerFactory(){

            @Override
            public Callable<StateChangeHandlerFactory.HandlerResult> createClientListChangedHandler(Collection<ClientState> clientList) {
                return () -> {
                    try {
                        String clientListString = clientList.stream().map(clientState -> Integer.toString(clientState.getPid())).collect(Collectors.joining("\n"));
                        TrackJdwpCommandHandler.write4ByteHexIntString(stream, clientListString.length());
                        TrackJdwpCommandHandler.writeString(stream, clientListString);
                        return new StateChangeHandlerFactory.HandlerResult(true);
                    }
                    catch (IOException ignored) {
                        return new StateChangeHandlerFactory.HandlerResult(false);
                    }
                };
            }

            @Override
            public Callable<StateChangeHandlerFactory.HandlerResult> createLogcatMessageAdditionHandler(String message) {
                return () -> new StateChangeHandlerFactory.HandlerResult(true);
            }
        });
        if (queue == null) {
            return false;
        }
        try {
            TrackJdwpCommandHandler.writeOkay(stream);
            while (queue.take().call().mShouldContinue) {
            }
        }
        catch (Exception exception) {
        }
        finally {
            device.getClientChangeHub().unsubscribe(queue);
        }
        return false;
    }
}

