/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeviceSelectionModel {
    private final Map<IHvDevice, DeviceInfo> mDeviceMap = new HashMap<IHvDevice, DeviceInfo>(10);
    private final Map<IHvDevice, Integer> mFocusedWindowHashes = new HashMap<IHvDevice, Integer>(20);
    private final ArrayList<IWindowChangeListener> mWindowChangeListeners = new ArrayList();
    private IHvDevice mSelectedDevice;
    private Window mSelectedWindow;
    private static DeviceSelectionModel sModel;

    public static DeviceSelectionModel getModel() {
        if (sModel == null) {
            sModel = new DeviceSelectionModel();
        }
        return sModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(IHvDevice hvDevice) {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            DeviceInfo info = new DeviceInfo(hvDevice.getWindows());
            this.mDeviceMap.put(hvDevice, info);
        }
        this.notifyDeviceConnected(hvDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDevice(IHvDevice hvDevice) {
        boolean selectionChanged = false;
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            this.mDeviceMap.remove(hvDevice);
            this.mFocusedWindowHashes.remove(hvDevice);
            if (this.mSelectedDevice == hvDevice) {
                this.mSelectedDevice = null;
                this.mSelectedWindow = null;
                selectionChanged = true;
            }
        }
        this.notifyDeviceDisconnected(hvDevice);
        if (selectionChanged) {
            this.notifySelectionChanged(this.mSelectedDevice, this.mSelectedWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevice(IHvDevice hvDevice) {
        boolean selectionChanged = false;
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            Window[] windows = hvDevice.getWindows();
            this.mDeviceMap.put(hvDevice, new DeviceInfo(windows));
            if (this.mSelectedDevice == hvDevice && this.mSelectedWindow != null) {
                boolean windowStillExists = false;
                for (int i = 0; i < windows.length && !windowStillExists; ++i) {
                    if (!windows[i].equals(this.mSelectedWindow)) continue;
                    windowStillExists = true;
                }
                if (!windowStillExists) {
                    this.mSelectedDevice = null;
                    this.mSelectedWindow = null;
                    selectionChanged = true;
                }
            }
        }
        this.notifyDeviceChanged(hvDevice);
        if (selectionChanged) {
            this.notifySelectionChanged(this.mSelectedDevice, this.mSelectedWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFocusedWindow(IHvDevice device, int focusedWindow) {
        Integer oldValue = null;
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            oldValue = this.mFocusedWindowHashes.put(device, new Integer(focusedWindow));
        }
        if (oldValue == null || oldValue != null && oldValue != focusedWindow) {
            this.notifyFocusChanged(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWindowChangeListener[] getWindowChangeListenerList() {
        IWindowChangeListener[] listeners = null;
        ArrayList<IWindowChangeListener> arrayList = this.mWindowChangeListeners;
        synchronized (arrayList) {
            if (this.mWindowChangeListeners.size() == 0) {
                return null;
            }
            listeners = this.mWindowChangeListeners.toArray(new IWindowChangeListener[this.mWindowChangeListeners.size()]);
        }
        return listeners;
    }

    private void notifyDeviceConnected(IHvDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].deviceConnected(device);
            }
        }
    }

    private void notifyDeviceChanged(IHvDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].deviceChanged(device);
            }
        }
    }

    private void notifyDeviceDisconnected(IHvDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].deviceDisconnected(device);
            }
        }
    }

    private void notifyFocusChanged(IHvDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].focusChanged(device);
            }
        }
    }

    private void notifySelectionChanged(IHvDevice device, Window window) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].selectionChanged(device, window);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(IWindowChangeListener listener) {
        ArrayList<IWindowChangeListener> arrayList = this.mWindowChangeListeners;
        synchronized (arrayList) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(IWindowChangeListener listener) {
        ArrayList<IWindowChangeListener> arrayList = this.mWindowChangeListeners;
        synchronized (arrayList) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHvDevice[] getDevices() {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            Set<IHvDevice> devices = this.mDeviceMap.keySet();
            return devices.toArray(new IHvDevice[devices.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window[] getWindows(IHvDevice device) {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            DeviceInfo info = this.mDeviceMap.get(device);
            if (info != null) {
                return info.windows;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFocusedWindow(IHvDevice device) {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            Integer focusedWindow = this.mFocusedWindowHashes.get(device);
            if (focusedWindow == null) {
                return -1;
            }
            return focusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(IHvDevice device, Window window) {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            this.mSelectedDevice = device;
            this.mSelectedWindow = window;
        }
        this.notifySelectionChanged(device, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHvDevice getSelectedDevice() {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            return this.mSelectedDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getSelectedWindow() {
        Map<IHvDevice, DeviceInfo> map = this.mDeviceMap;
        synchronized (map) {
            return this.mSelectedWindow;
        }
    }

    public static interface IWindowChangeListener {
        public void deviceConnected(IHvDevice var1);

        public void deviceChanged(IHvDevice var1);

        public void deviceDisconnected(IHvDevice var1);

        public void focusChanged(IHvDevice var1);

        public void selectionChanged(IHvDevice var1, Window var2);
    }

    private static class DeviceInfo {
        Window[] windows;

        private DeviceInfo(Window[] windows) {
            this.windows = windows;
        }
    }
}

