/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.models.EvaluateContrastModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EvaluateContrastDisplay {
    private static final int DEFAULT_HEIGHT = 600;
    private static final int MARGIN = 30;
    private static final int PALLETE_IMAGE_SIZE = 16;
    private static final int IMAGE_WIDTH = 800;
    private static final int RESULTS_PANEL_WIDTH = 300;
    private static final int MAX_NUM_CHARACTERS = 35;
    private static final String ABBREVIATE_SUFFIX = "...\"";
    private static Shell sShell;
    private static Canvas sCanvas;
    private static Composite sResultsPanel;
    private static Tree sResultsTree;
    private static Image sImage;
    private static Point sImageOffset;
    private static ScrollBar sImageScrollBar;
    private static int sImageWidth;
    private static int sImageHeight;
    private static Image sYellowImage;
    private static Image sRedImage;
    private static Image sGreenImage;
    private static ViewNode sSelectedNode;
    private static Color sBorderColorPass;
    private static Color sBorderColorFail;
    private static Color sBorderColorIndeterminate;
    private static Color sBorderColorCurrentlySelected;
    private static HashMap<ViewNode, Rectangle> sRectangleForViewNode;
    private static HashMap<ViewNode, Color> sBorderColorForViewNode;
    private static HashMap<ViewNode, EvaluateContrastModel> sViewNodeForModel;
    private static HashMap<Integer, Image> sImageForColor;
    private static HashMap<TreeItem, ViewNode> sViewNodeForTreeItem;
    private static double sScaleFactor;
    private static ShellAdapter sShellListener;

    private static Color getBorderColorPass() {
        if (sBorderColorPass == null) {
            sBorderColorPass = new Color((Device)Display.getDefault(), new RGB(0, 255, 0));
        }
        return sBorderColorPass;
    }

    private static Color getBorderColorFail() {
        if (sBorderColorFail == null) {
            sBorderColorFail = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
        }
        return sBorderColorFail;
    }

    private static Color getBorderColorIndeterminate() {
        if (sBorderColorIndeterminate == null) {
            sBorderColorIndeterminate = new Color((Device)Display.getDefault(), new RGB(255, 255, 0));
        }
        return sBorderColorIndeterminate;
    }

    private static Color getBorderColorCurrentlySelected() {
        if (sBorderColorCurrentlySelected == null) {
            sBorderColorCurrentlySelected = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
        }
        return sBorderColorCurrentlySelected;
    }

    private static void clear(boolean shellIsNull) {
        sRectangleForViewNode.clear();
        sBorderColorForViewNode.clear();
        sViewNodeForModel.clear();
        if (!shellIsNull) {
            sImage.dispose();
            for (Image image : sImageForColor.values()) {
                image.dispose();
            }
            sImageForColor.clear();
            sViewNodeForTreeItem.clear();
            for (Control item : sShell.getChildren()) {
                item.dispose();
            }
        }
        if (sBorderColorPass != null) {
            sBorderColorPass.dispose();
            sBorderColorPass = null;
        }
        if (sBorderColorFail != null) {
            sBorderColorFail.dispose();
            sBorderColorFail = null;
        }
        if (sBorderColorIndeterminate != null) {
            sBorderColorIndeterminate.dispose();
            sBorderColorIndeterminate = null;
        }
        if (sBorderColorCurrentlySelected != null) {
            sBorderColorCurrentlySelected.dispose();
            sBorderColorCurrentlySelected = null;
        }
    }

    private static Image scaleImage(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setInterpolation(2);
        gc.setAntialias(1);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        image.dispose();
        gc.dispose();
        return scaled;
    }

    public static void show(Shell parentShell, ViewNode rootNode, Image image) {
        EvaluateContrastDisplay.clear(sShell == null);
        sScaleFactor = Math.min(800.0 / (double)image.getBounds().width, 1.0);
        sImage = EvaluateContrastDisplay.scaleImage(image, 800, (int)Math.round((double)image.getBounds().height * sScaleFactor));
        sImageWidth = EvaluateContrastDisplay.sImage.getBounds().width;
        sImageHeight = EvaluateContrastDisplay.sImage.getBounds().height;
        if (sShell == null) {
            sShell = new Shell(Display.getDefault(), 96);
            sShell.setText("Evaluate Contrast");
            sShell.addShellListener((ShellListener)sShellListener);
            sShell.setLayout((Layout)new GridLayout(2, false));
        }
        EvaluateContrastDisplay.buildContents((Composite)sShell);
        EvaluateContrastDisplay.processEvaluatableChildViews(rootNode);
        sShell.setLocation(parentShell.getBounds().x, parentShell.getBounds().y);
        sShell.setSize(1130, 660);
        sImageScrollBar.setMaximum(EvaluateContrastDisplay.sImage.getBounds().height);
        sImageScrollBar.setThumb(600);
        sShell.open();
        sShell.layout();
    }

    private static void buildContents(Composite shell) {
        EvaluateContrastDisplay.buildResultsPanel();
        EvaluateContrastDisplay.buildImagePanel(shell);
    }

    private static void buildResultsPanel() {
        sResultsPanel = new Composite((Composite)sShell, 0);
        sResultsPanel.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(1, 1, false, true);
        sResultsPanel.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(sResultsPanel, 512);
        sResultsTree = new Tree((Composite)scrolledComposite, 0);
        sResultsTree.setLinesVisible(true);
        scrolledComposite.setContent((Control)sResultsTree);
        sResultsTree.setSize(300, 600);
        sResultsTree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                Image image = (Image)item.getData();
                if (image != null) {
                    int x = event.x + event.width;
                    int itemHeight = sResultsTree.getItemHeight();
                    int imageHeight = image.getBounds().height;
                    int y = event.y + (itemHeight - imageHeight) / 2;
                    event.gc.drawImage(image, x, y);
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                TreeItem treeItem = (TreeItem)e.item;
                if (treeItem.getItemCount() == 0) {
                    while ((treeItem = treeItem.getParentItem()).getParentItem() != null) {
                    }
                }
                ViewNode node = (ViewNode)sViewNodeForTreeItem.get(treeItem);
                if (sSelectedNode != node) {
                    sSelectedNode = (ViewNode)sViewNodeForTreeItem.get(treeItem);
                    sCanvas.redraw();
                }
            }
        };
        sResultsTree.addListener(13, listener);
        sResultsTree.addListener(14, listener);
    }

    private static void buildImagePanel(Composite parent) {
        sImageOffset = new Point(0, 0);
        sCanvas = new Canvas(parent, 1311232);
        sCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int marginHeight;
                GC gc = e.gc;
                gc.drawImage(sImage, sImageOffset.x, sImageOffset.y);
                for (ViewNode viewNode : sRectangleForViewNode.keySet()) {
                    Rectangle rectangle = (Rectangle)sRectangleForViewNode.get(viewNode);
                    if (sSelectedNode == viewNode) {
                        e.gc.setForeground(EvaluateContrastDisplay.getBorderColorCurrentlySelected());
                    } else {
                        e.gc.setForeground((Color)sBorderColorForViewNode.get(viewNode));
                    }
                    e.gc.drawRectangle(Math.max(0, sImageOffset.x + rectangle.x - 1), sImageOffset.y + rectangle.y - 1, rectangle.width - 1, rectangle.height - 1);
                }
                Rectangle rect = sImage.getBounds();
                Rectangle client = sCanvas.getClientArea();
                int marginWidth = client.width - rect.width;
                if (marginWidth > 0) {
                    gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                }
                if ((marginHeight = client.height - rect.height) > 0) {
                    gc.fillRectangle(0, rect.height, client.width, marginHeight);
                }
            }
        });
        sImageScrollBar = sCanvas.getVerticalBar();
        sImageScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int offset = sImageScrollBar.getSelection();
                Rectangle imageBounds = sImage.getBounds();
                sImageOffset.y = -offset;
                int y = -offset - sImageOffset.y;
                sCanvas.scroll(0, y, 0, 0, imageBounds.width, imageBounds.height, false);
                sCanvas.redraw();
            }
        });
        GridData gridData = new GridData(1, 1, true, true);
        gridData.widthHint = 830;
        gridData.heightHint = 600;
        sCanvas.setLayoutData((Object)gridData);
    }

    private static void processEvaluatableChildViews(ViewNode root) {
        List<ViewNode> children = EvaluateContrastDisplay.getEvaluatableChildViews(root);
        for (ViewNode child : children) {
            EvaluateContrastDisplay.calculateRectangleForViewNode(child);
            EvaluateContrastModel evaluateContrastModel = EvaluateContrastDisplay.evaluateContrastForView(child);
            if (evaluateContrastModel != null) {
                EvaluateContrastDisplay.calculateBorderColorForViewNode(child, evaluateContrastModel.getContrastResult());
                EvaluateContrastDisplay.buildTreeItem(evaluateContrastModel, child);
                sViewNodeForModel.put(child, evaluateContrastModel);
                continue;
            }
            sRectangleForViewNode.remove(child);
        }
    }

    private static void buildTreeItem(EvaluateContrastModel model, ViewNode child) {
        int dotIndex = child.name.lastIndexOf(46);
        String shortName = dotIndex == -1 ? child.name : child.name.substring(dotIndex + 1);
        String text = shortName + ": \"" + child.namedProperties.get((Object)"text:mText").value + "\"";
        TreeItem item = new TreeItem(sResultsTree, 0);
        item.setText(EvaluateContrastDisplay.transformText(text, 35));
        item.setImage(EvaluateContrastDisplay.getResultImage(model.getContrastResult()));
        sViewNodeForTreeItem.put(item, child);
        EvaluateContrastDisplay.buildTreeItemsForModel(model, item);
    }

    private static Image buildImageForColor(int color) {
        Image image = sImageForColor.get(color);
        if (image == null) {
            image = new Image((Device)Display.getDefault(), 16, 16);
            GC gc = new GC((Drawable)image);
            Color swtColor = EvaluateContrastDisplay.awtColortoSwtColor(new java.awt.Color(color));
            gc.setBackground(swtColor);
            swtColor.dispose();
            gc.fillRectangle(0, 0, 16, 16);
            swtColor = EvaluateContrastDisplay.awtColortoSwtColor(java.awt.Color.BLACK);
            gc.setForeground(swtColor);
            swtColor.dispose();
            gc.drawRectangle(0, 0, 15, 15);
            gc.dispose();
            sImageForColor.put(color, image);
        }
        return image;
    }

    public static Color awtColortoSwtColor(java.awt.Color color) {
        return new Color((Device)Display.getDefault(), color.getRed(), color.getGreen(), color.getBlue());
    }

    private static void buildTreeItemsForModel(EvaluateContrastModel model, TreeItem parent) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText("Text color: " + model.getTextColorHex());
        item.setData((Object)EvaluateContrastDisplay.buildImageForColor(model.getTextColor()));
        item = new TreeItem(parent, 0);
        item.setText("Background color: " + model.getBackgroundColorHex());
        item.setData((Object)EvaluateContrastDisplay.buildImageForColor(model.getBackgroundColor()));
        new TreeItem(parent, 0).setText("Text size: " + model.getTextSize());
        new TreeItem(parent, 0).setText("Contrast ratio: " + String.format("%.2f:1", model.getContrastRatio()));
        if (!model.isIndeterminate()) {
            new TreeItem(parent, 0).setText("Test: " + model.getContrastResult().name());
        } else {
            item = new TreeItem(parent, 0);
            item.setText("Normal Text Test: " + model.getContrastResultForNormalText().name());
            item.setImage(EvaluateContrastDisplay.getResultImage(model.getContrastResultForNormalText()));
            item = new TreeItem(parent, 0);
            item.setText("Large Text Test: " + model.getContrastResultForLargeText().name());
            item.setImage(EvaluateContrastDisplay.getResultImage(model.getContrastResultForLargeText()));
        }
    }

    private static List<ViewNode> getEvaluatableChildViews(ViewNode root) {
        ArrayList<ViewNode> children = new ArrayList<ViewNode>();
        children.add(root);
        for (int i = 0; i < children.size(); ++i) {
            ViewNode node = (ViewNode)children.get(i);
            List<ViewNode> temp = node.children;
            for (ViewNode child : temp) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        }
        ArrayList<ViewNode> evalutableChildren = new ArrayList<ViewNode>();
        for (ViewNode child : children) {
            if (child.namedProperties.get("text:mText") == null) continue;
            evalutableChildren.add(child);
        }
        return evalutableChildren;
    }

    private static void calculateBorderColorForViewNode(ViewNode node, EvaluateContrastModel.ContrastResult result) {
        Color borderColor;
        switch (result) {
            case PASS: {
                borderColor = EvaluateContrastDisplay.getBorderColorPass();
                break;
            }
            case FAIL: {
                borderColor = EvaluateContrastDisplay.getBorderColorFail();
                break;
            }
            default: {
                borderColor = EvaluateContrastDisplay.getBorderColorIndeterminate();
            }
        }
        sBorderColorForViewNode.put(node, borderColor);
    }

    private static Image getResultImage(EvaluateContrastModel.ContrastResult result) {
        switch (result) {
            case PASS: {
                return sGreenImage;
            }
            case FAIL: {
                return sRedImage;
            }
        }
        return sYellowImage;
    }

    private static String transformText(String text, int maxNumCharacters) {
        if (text.length() == maxNumCharacters) {
            return text;
        }
        if (text.length() < maxNumCharacters) {
            char[] filler = new char[maxNumCharacters - text.length()];
            Arrays.fill(filler, ' ');
            return text + new String(filler);
        }
        StringBuilder abbreviatedText = new StringBuilder();
        abbreviatedText.append(text.substring(0, maxNumCharacters - ABBREVIATE_SUFFIX.length()));
        abbreviatedText.append(ABBREVIATE_SUFFIX);
        return abbreviatedText.toString();
    }

    private static void calculateRectangleForViewNode(ViewNode viewNode) {
        int leftShift = 0;
        int topShift = 0;
        int nodeLeft = (int)Math.round((double)viewNode.left * sScaleFactor);
        int nodeTop = (int)Math.round((double)viewNode.top * sScaleFactor);
        int nodeWidth = (int)Math.round((double)viewNode.width * sScaleFactor);
        int nodeHeight = (int)Math.round((double)viewNode.height * sScaleFactor);
        ViewNode current = viewNode;
        while (current.parent != null) {
            leftShift += (int)Math.round(sScaleFactor * (double)(current.parent.left - current.parent.scrollX));
            topShift += (int)Math.round(sScaleFactor * (double)(current.parent.top - current.parent.scrollY));
            current = current.parent;
        }
        sRectangleForViewNode.put(viewNode, new Rectangle(leftShift + nodeLeft, topShift + nodeTop, nodeWidth, nodeHeight));
    }

    private static EvaluateContrastModel evaluateContrastForView(ViewNode node) {
        boolean isBold;
        Map<String, ViewNode.Property> namedProperties = node.namedProperties;
        ViewNode.Property textColorProperty = namedProperties.get("text:mCurTextColor");
        Integer textColor = textColorProperty == null ? null : Integer.valueOf(textColorProperty.value);
        ViewNode.Property textSizeProperty = namedProperties.get("text:getScaledTextSize()");
        Double textSize = textSizeProperty == null ? null : Double.valueOf(textSizeProperty.value);
        Rectangle rectangle = sRectangleForViewNode.get(node);
        ViewNode.Property boldProperty = namedProperties.get("text:getTypefaceStyle()");
        boolean bl = isBold = boldProperty != null && boldProperty.value.equals("BOLD");
        if (rectangle.x < 0 || rectangle.x > sImageWidth || rectangle.y < 0 || rectangle.y > sImageHeight || rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        int x = Math.max(0, rectangle.x);
        int y = Math.max(0, rectangle.y);
        int width = Math.min(sImageWidth, rectangle.x + rectangle.width);
        int height = Math.min(sImageHeight, rectangle.y + rectangle.height);
        return new EvaluateContrastModel(sImage, textColor, textSize, x, y, width, height, isBold);
    }

    static {
        sImageForColor = new HashMap();
        sViewNodeForTreeItem = new HashMap();
        ImageLoader loader = ImageLoader.getLoader(EvaluateContrastDisplay.class);
        sYellowImage = loader.loadImage("yellow.png", Display.getDefault());
        sRedImage = loader.loadImage("red.png", Display.getDefault());
        sGreenImage = loader.loadImage("green.png", Display.getDefault());
        sRectangleForViewNode = new HashMap();
        sBorderColorForViewNode = new HashMap();
        sViewNodeForModel = new HashMap();
        sShellListener = new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
                sShell.setVisible(false);
                EvaluateContrastDisplay.clear(sShell == null);
            }
        };
    }
}

