/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import java.text.DecimalFormat;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TreeView
extends Canvas
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private DrawableViewNode mTree;
    private DrawableViewNode mSelectedNode;
    private DrawableViewNode.Rectangle mViewport;
    private Transform mTransform;
    private Transform mInverse;
    private double mZoom;
    private DrawableViewNode.Point mLastPoint;
    private boolean mAlreadySelectedOnMouseDown;
    private boolean mDoubleClicked;
    private boolean mNodeMoved;
    private DrawableViewNode mDraggedNode;
    public static final int LINE_PADDING = 10;
    public static final float BEZIER_FRACTION = 0.35f;
    private static Image sRedImage;
    private static Image sYellowImage;
    private static Image sGreenImage;
    private static Image sNotSelectedImage;
    private static Image sSelectedImage;
    private static Image sFilteredImage;
    private static Image sFilteredSelectedImage;
    private static Font sSystemFont;
    private Color mBoxColor;
    private Color mTextBackgroundColor;
    private DrawableViewNode.Rectangle mSelectedRectangleLocation;
    private DrawableViewNode.Point mButtonCenter;
    private static final int BUTTON_SIZE = 13;
    private Image mScaledSelectedImage;
    private boolean mButtonClicked;
    private DrawableViewNode mLastDrawnSelectedViewNode;
    private static final int DRAG_LEEWAY = 220;
    private static final int RECT_WIDTH = 190;
    private static final int RECT_HEIGHT = 224;
    private static final int BUTTON_RIGHT_OFFSET = 5;
    private static final int BUTTON_TOP_OFFSET = 5;
    private static final int IMAGE_WIDTH = 125;
    private static final int IMAGE_HEIGHT = 120;
    private static final int IMAGE_OFFSET = 6;
    private static final int IMAGE_ROUNDING = 8;
    private static final int RECTANGLE_SIZE = 5;
    private static final int TEXT_SIDE_OFFSET = 8;
    private static final int TEXT_TOP_OFFSET = 4;
    private static final int TEXT_SPACING = 2;
    private static final int TEXT_ROUNDING = 20;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            TreeView.this.mModel.removeTreeChangeListener(TreeView.this);
            TreeView.this.mTransform.dispose();
            TreeView.this.mInverse.dispose();
            TreeView.this.mBoxColor.dispose();
            TreeView.this.mTextBackgroundColor.dispose();
            if (TreeView.this.mTree != null) {
                TreeView.this.mModel.setViewport(null);
            }
        }
    };
    private Listener mResizeListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event e) {
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null) {
                    DrawableViewNode.Point viewCenter = new DrawableViewNode.Point(((TreeView)TreeView.this).mViewport.x + ((TreeView)TreeView.this).mViewport.width / 2.0, ((TreeView)TreeView.this).mViewport.y + ((TreeView)TreeView.this).mViewport.height / 2.0);
                    ((TreeView)TreeView.this).mViewport.width = (double)TreeView.this.getBounds().width / TreeView.this.mZoom;
                    ((TreeView)TreeView.this).mViewport.height = (double)TreeView.this.getBounds().height / TreeView.this.mZoom;
                    ((TreeView)TreeView.this).mViewport.x = viewCenter.x - ((TreeView)TreeView.this).mViewport.width / 2.0;
                    ((TreeView)TreeView.this).mViewport.y = viewCenter.y - ((TreeView)TreeView.this).mViewport.height / 2.0;
                }
            }
            if (TreeView.this.mViewport != null) {
                TreeView.this.mModel.setViewport(TreeView.this.mViewport);
            }
        }
    };
    private KeyListener mKeyListener = new KeyListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            boolean selectionChanged = false;
            DrawableViewNode clickedNode = null;
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null && TreeView.this.mSelectedNode != null) {
                    switch (e.keyCode) {
                        case 0x1000003: {
                            if (((TreeView)TreeView.this).mSelectedNode.parent == null) break;
                            TreeView.this.mSelectedNode = ((TreeView)TreeView.this).mSelectedNode.parent;
                            selectionChanged = true;
                            break;
                        }
                        case 0x1000001: {
                            DrawableViewNode currentNode = TreeView.this.mSelectedNode;
                            while (currentNode.parent != null && currentNode.viewNode.index == 0) {
                                currentNode = currentNode.parent;
                            }
                            if (currentNode.parent != null) {
                                selectionChanged = true;
                                currentNode = currentNode.parent.children.get(currentNode.viewNode.index - 1);
                                while (currentNode.children.size() != 0) {
                                    currentNode = currentNode.children.get(currentNode.children.size() - 1);
                                }
                            }
                            if (!selectionChanged) break;
                            TreeView.this.mSelectedNode = currentNode;
                            break;
                        }
                        case 0x1000002: {
                            DrawableViewNode currentNode = TreeView.this.mSelectedNode;
                            while (currentNode.parent != null && currentNode.viewNode.index + 1 == currentNode.parent.children.size()) {
                                currentNode = currentNode.parent;
                            }
                            if (currentNode.parent != null) {
                                selectionChanged = true;
                                currentNode = currentNode.parent.children.get(currentNode.viewNode.index + 1);
                                while (currentNode.children.size() != 0) {
                                    currentNode = currentNode.children.get(0);
                                }
                            }
                            if (!selectionChanged) break;
                            TreeView.this.mSelectedNode = currentNode;
                            break;
                        }
                        case 0x1000004: {
                            DrawableViewNode rightNode = null;
                            double mostOverlap = 0.0;
                            int N = ((TreeView)TreeView.this).mSelectedNode.children.size();
                            for (int i = 0; i < N; ++i) {
                                DrawableViewNode child;
                                DrawableViewNode topMostChild = child = ((TreeView)TreeView.this).mSelectedNode.children.get(i);
                                while (topMostChild.children.size() != 0) {
                                    topMostChild = topMostChild.children.get(0);
                                }
                                double overlap = Math.min(100.0, Math.min(((TreeView)TreeView.this).mSelectedNode.top + 100.0 - topMostChild.top, topMostChild.top + (double)child.treeHeight - ((TreeView)TreeView.this).mSelectedNode.top));
                                if (!(overlap > mostOverlap)) continue;
                                mostOverlap = overlap;
                                rightNode = child;
                            }
                            if (rightNode == null) break;
                            TreeView.this.mSelectedNode = rightNode;
                            selectionChanged = true;
                            break;
                        }
                        case 13: {
                            clickedNode = TreeView.this.mSelectedNode;
                        }
                    }
                }
            }
            if (selectionChanged) {
                TreeView.this.mModel.setSelection(TreeView.this.mSelectedNode);
            }
            if (clickedNode != null) {
                HierarchyViewerDirector.getDirector().showCapture(TreeView.this.getShell(), clickedNode.viewNode);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDoubleClick(MouseEvent e) {
            DrawableViewNode clickedNode = null;
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null) {
                    DrawableViewNode.Point pt = TreeView.this.transformPoint(e.x, e.y);
                    clickedNode = TreeView.this.mTree.getSelected(pt.x, pt.y);
                }
            }
            if (clickedNode != null) {
                HierarchyViewerDirector.getDirector().showCapture(TreeView.this.getShell(), clickedNode.viewNode);
                TreeView.this.mDoubleClicked = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDown(MouseEvent e) {
            boolean selectionChanged = false;
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null) {
                    DrawableViewNode.Point pt = TreeView.this.transformPoint(e.x, e.y);
                    if (TreeView.this.mSelectedRectangleLocation != null && pt.x >= ((TreeView)TreeView.this).mSelectedRectangleLocation.x && pt.x < ((TreeView)TreeView.this).mSelectedRectangleLocation.x + ((TreeView)TreeView.this).mSelectedRectangleLocation.width && pt.y >= ((TreeView)TreeView.this).mSelectedRectangleLocation.y && pt.y < ((TreeView)TreeView.this).mSelectedRectangleLocation.y + ((TreeView)TreeView.this).mSelectedRectangleLocation.height) {
                        if ((pt.x - ((TreeView)TreeView.this).mButtonCenter.x) * (pt.x - ((TreeView)TreeView.this).mButtonCenter.x) + (pt.y - ((TreeView)TreeView.this).mButtonCenter.y) * (pt.y - ((TreeView)TreeView.this).mButtonCenter.y) <= 42.0) {
                            TreeView.this.mButtonClicked = true;
                            TreeView.this.doRedraw();
                        }
                        return;
                    }
                    TreeView.this.mDraggedNode = TreeView.this.mTree.getSelected(pt.x, pt.y);
                    if (TreeView.this.mDraggedNode != null && TreeView.this.mDraggedNode != TreeView.this.mSelectedNode) {
                        TreeView.this.mSelectedNode = TreeView.this.mDraggedNode;
                        selectionChanged = true;
                        TreeView.this.mAlreadySelectedOnMouseDown = false;
                    } else if (TreeView.this.mDraggedNode != null) {
                        TreeView.this.mAlreadySelectedOnMouseDown = true;
                    }
                    if (TreeView.this.mDraggedNode == TreeView.this.mTree) {
                        TreeView.this.mDraggedNode = null;
                    }
                    if (TreeView.this.mDraggedNode != null) {
                        TreeView.this.mLastPoint = pt;
                    } else {
                        TreeView.this.mLastPoint = new DrawableViewNode.Point(e.x, e.y);
                    }
                    TreeView.this.mNodeMoved = false;
                    TreeView.this.mDoubleClicked = false;
                }
            }
            if (selectionChanged) {
                TreeView.this.mModel.setSelection(TreeView.this.mSelectedNode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseUp(MouseEvent e) {
            boolean redraw = false;
            boolean redrawButton = false;
            boolean viewportChanged = false;
            boolean selectionChanged = false;
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null && TreeView.this.mLastPoint != null) {
                    if (TreeView.this.mDraggedNode == null) {
                        TreeView.this.handleMouseDrag(new DrawableViewNode.Point(e.x, e.y));
                        viewportChanged = true;
                    } else {
                        TreeView.this.handleMouseDrag(TreeView.this.transformPoint(e.x, e.y));
                    }
                    DrawableViewNode.Point pt = TreeView.this.transformPoint(e.x, e.y);
                    DrawableViewNode mouseUpOn = TreeView.this.mTree.getSelected(pt.x, pt.y);
                    if (mouseUpOn != null && mouseUpOn == TreeView.this.mSelectedNode && TreeView.this.mAlreadySelectedOnMouseDown && !TreeView.this.mNodeMoved && !TreeView.this.mDoubleClicked) {
                        TreeView.this.mSelectedNode = null;
                        selectionChanged = true;
                    }
                    TreeView.this.mLastPoint = null;
                    TreeView.this.mDraggedNode = null;
                    redraw = true;
                }
                if (TreeView.this.mButtonClicked) {
                    HierarchyViewerDirector.getDirector().showCapture(TreeView.this.getShell(), ((TreeView)TreeView.this).mSelectedNode.viewNode);
                    TreeView.this.mButtonClicked = false;
                    redrawButton = true;
                }
            }
            if (viewportChanged) {
                TreeView.this.mModel.setViewport(TreeView.this.mViewport);
            } else if (redraw) {
                TreeView.this.mModel.removeTreeChangeListener(TreeView.this);
                TreeView.this.mModel.notifyViewportChanged();
                if (selectionChanged) {
                    TreeView.this.mModel.setSelection(TreeView.this.mSelectedNode);
                }
                TreeView.this.mModel.addTreeChangeListener(TreeView.this);
                TreeView.this.doRedraw();
            } else if (redrawButton) {
                TreeView.this.doRedraw();
            }
        }
    };
    private MouseMoveListener mMouseMoveListener = new MouseMoveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMove(MouseEvent e) {
            boolean redraw = false;
            boolean viewportChanged = false;
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null && TreeView.this.mLastPoint != null) {
                    if (TreeView.this.mDraggedNode == null) {
                        TreeView.this.handleMouseDrag(new DrawableViewNode.Point(e.x, e.y));
                        viewportChanged = true;
                    } else {
                        TreeView.this.handleMouseDrag(TreeView.this.transformPoint(e.x, e.y));
                    }
                    redraw = true;
                }
            }
            if (viewportChanged) {
                TreeView.this.mModel.setViewport(TreeView.this.mViewport);
            } else if (redraw) {
                TreeView.this.mModel.removeTreeChangeListener(TreeView.this);
                TreeView.this.mModel.notifyViewportChanged();
                TreeView.this.mModel.addTreeChangeListener(TreeView.this);
                TreeView.this.doRedraw();
            }
        }
    };
    private MouseWheelListener mMouseWheelListener = new MouseWheelListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseScrolled(MouseEvent e) {
            DrawableViewNode.Point zoomPoint = null;
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null) {
                    TreeView.this.mZoom = TreeView.this.mZoom + Math.ceil((double)e.count / 3.0) * 0.1;
                    zoomPoint = TreeView.this.transformPoint(e.x, e.y);
                }
            }
            if (zoomPoint != null) {
                TreeView.this.mModel.zoomOnPoint(TreeView.this.mZoom, zoomPoint);
            }
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent e) {
            TreeView treeView = TreeView.this;
            synchronized (treeView) {
                e.gc.setBackground(Display.getDefault().getSystemColor(2));
                e.gc.fillRectangle(0, 0, TreeView.this.getBounds().width, TreeView.this.getBounds().height);
                if (TreeView.this.mTree != null && TreeView.this.mViewport != null) {
                    e.gc.setTransform(TreeView.this.mTransform);
                    e.gc.setForeground(Display.getDefault().getSystemColor(1));
                    Path connectionPath = new Path((Device)Display.getDefault());
                    TreeView.paintRecursive(e.gc, TreeView.this.mTransform, TreeView.this.mTree, TreeView.this.mSelectedNode, connectionPath);
                    e.gc.drawPath(connectionPath);
                    connectionPath.dispose();
                    if (TreeView.this.mSelectedNode != null) {
                        e.gc.setAlpha(200);
                        int x = ((TreeView)TreeView.this).mSelectedNode.left + 90;
                        int y = (int)((TreeView)TreeView.this).mSelectedNode.top + 4;
                        e.gc.setBackground(TreeView.this.mBoxColor);
                        e.gc.fillPolygon(new int[]{x, y, x - 11, y - 11, x + 11, y - 11});
                        e.gc.fillRoundRectangle(x - 95, y -= 234, 190, 224, 30, 30);
                        TreeView.this.mSelectedRectangleLocation = new DrawableViewNode.Rectangle(x - 95, y, 190.0, 224.0);
                        e.gc.setAlpha(255);
                        TreeView.this.mButtonCenter = new DrawableViewNode.Point(x - 5 + 88, y + 5 + 6);
                        if (TreeView.this.mButtonClicked) {
                            e.gc.setBackground(Display.getDefault().getSystemColor(2));
                        } else {
                            e.gc.setBackground(TreeView.this.mTextBackgroundColor);
                        }
                        e.gc.setForeground(Display.getDefault().getSystemColor(1));
                        e.gc.fillOval(x + 95 - 5 - 13, y + 5, 13, 13);
                        e.gc.drawRectangle(x - 5 + 86 - 1, y + 5 + 4, 6, 5);
                        y += 15;
                        if (((TreeView)TreeView.this).mSelectedNode.viewNode.image != null && ((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().height != 1 && ((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().width != 1) {
                            if (TreeView.this.mLastDrawnSelectedViewNode != TreeView.this.mSelectedNode) {
                                if (TreeView.this.mScaledSelectedImage != null) {
                                    TreeView.this.mScaledSelectedImage.dispose();
                                    TreeView.this.mScaledSelectedImage = null;
                                }
                                TreeView.this.mLastDrawnSelectedViewNode = TreeView.this.mSelectedNode;
                            }
                            if (TreeView.this.mScaledSelectedImage == null) {
                                int newHeight;
                                int newWidth;
                                double ratio = 1.0 * (double)((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().width / (double)((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().height;
                                if (ratio > 1.0416666666666667) {
                                    newWidth = Math.min(125, ((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().width);
                                    newHeight = (int)((double)newWidth / ratio);
                                } else {
                                    newHeight = Math.min(120, ((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().height);
                                    newWidth = (int)((double)newHeight * ratio);
                                }
                                newWidth = Math.max(newWidth * 2, 1);
                                newHeight = Math.max(newHeight * 2, 1);
                                TreeView.this.mScaledSelectedImage = new Image((Device)Display.getDefault(), newWidth, newHeight);
                                GC gc = new GC((Drawable)TreeView.this.mScaledSelectedImage);
                                gc.setBackground(TreeView.this.mTextBackgroundColor);
                                gc.fillRectangle(0, 0, newWidth, newHeight);
                                gc.drawImage(((TreeView)TreeView.this).mSelectedNode.viewNode.image, 0, 0, ((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().width, ((TreeView)TreeView.this).mSelectedNode.viewNode.image.getBounds().height, 0, 0, newWidth, newHeight);
                                gc.dispose();
                            }
                            e.gc.setBackground(TreeView.this.mTextBackgroundColor);
                            e.gc.fillRoundRectangle(x - ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().width / 4 - 6, y + (120 - ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().height / 2) / 2 - 6, ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().width / 2 + 12, ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().height / 2 + 12, 8, 8);
                            int imageX = x - ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().width / 4;
                            int imageY = y + (120 - ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().height / 2) / 2;
                            Transform untransformedTransform = new Transform((Device)Display.getDefault());
                            e.gc.setTransform(untransformedTransform);
                            float[] pt = new float[]{imageX, imageY};
                            TreeView.this.mTransform.transform(pt);
                            e.gc.drawImage(TreeView.this.mScaledSelectedImage, 0, 0, ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().width, ((TreeView)TreeView.this).mScaledSelectedImage.getBounds().height, (int)pt[0], (int)pt[1], (int)((double)((TreeView)TreeView.this).mScaledSelectedImage.getBounds().width * TreeView.this.mZoom / 2.0), (int)((double)((TreeView)TreeView.this).mScaledSelectedImage.getBounds().height * TreeView.this.mZoom / 2.0));
                            untransformedTransform.dispose();
                            e.gc.setTransform(TreeView.this.mTransform);
                        }
                        y += 120;
                        y += 10;
                        Font font = TreeView.getFont(8, false);
                        e.gc.setFont(font);
                        String text = ((TreeView)TreeView.this).mSelectedNode.viewNode.viewCount + " view" + (((TreeView)TreeView.this).mSelectedNode.viewNode.viewCount != 1 ? "s" : "");
                        DecimalFormat formatter = new DecimalFormat("0.000");
                        String measureText = "Measure: " + (((TreeView)TreeView.this).mSelectedNode.viewNode.measureTime != -1.0 ? formatter.format(((TreeView)TreeView.this).mSelectedNode.viewNode.measureTime) + " ms" : "n/a");
                        String layoutText = "Layout: " + (((TreeView)TreeView.this).mSelectedNode.viewNode.layoutTime != -1.0 ? formatter.format(((TreeView)TreeView.this).mSelectedNode.viewNode.layoutTime) + " ms" : "n/a");
                        String drawText = "Draw: " + (((TreeView)TreeView.this).mSelectedNode.viewNode.drawTime != -1.0 ? formatter.format(((TreeView)TreeView.this).mSelectedNode.viewNode.drawTime) + " ms" : "n/a");
                        Point titleExtent = e.gc.stringExtent(text);
                        Point measureExtent = e.gc.stringExtent(measureText);
                        Point layoutExtent = e.gc.stringExtent(layoutText);
                        Point drawExtent = e.gc.stringExtent(drawText);
                        int boxWidth = Math.max(titleExtent.x, Math.max(measureExtent.x, Math.max(layoutExtent.x, drawExtent.x))) + 16;
                        int boxHeight = titleExtent.y + 2 + measureExtent.y + 2 + layoutExtent.y + 2 + drawExtent.y + 8;
                        e.gc.setBackground(TreeView.this.mTextBackgroundColor);
                        e.gc.fillRoundRectangle(x - boxWidth / 2, y, boxWidth, boxHeight, 20, 20);
                        e.gc.setForeground(Display.getDefault().getSystemColor(1));
                        e.gc.drawText(text, x - titleExtent.x / 2, y += 4, true);
                        x -= boxWidth / 2;
                        e.gc.drawText(measureText, x += 8, y += titleExtent.y + 2, true);
                        e.gc.drawText(layoutText, x, y += measureExtent.y + 2, true);
                        e.gc.drawText(drawText, x, y += layoutExtent.y + 2, true);
                        font.dispose();
                    } else {
                        TreeView.this.mSelectedRectangleLocation = null;
                        TreeView.this.mButtonCenter = null;
                    }
                }
            }
        }
    };

    public TreeView(Composite parent) {
        super(parent, 0);
        this.mModel = TreeViewModel.getModel();
        this.mModel.addTreeChangeListener(this);
        this.addPaintListener(this.mPaintListener);
        this.addMouseListener(this.mMouseListener);
        this.addMouseMoveListener(this.mMouseMoveListener);
        this.addMouseWheelListener(this.mMouseWheelListener);
        this.addListener(11, this.mResizeListener);
        this.addDisposeListener(this.mDisposeListener);
        this.addKeyListener(this.mKeyListener);
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.loadResources();
        this.mTransform = new Transform((Device)Display.getDefault());
        this.mInverse = new Transform((Device)Display.getDefault());
        this.loadAllData();
    }

    private void loadResources() {
        ImageLoader loader = ImageLoader.getLoader(this.getClass());
        sRedImage = loader.loadImage("red.png", Display.getDefault());
        sYellowImage = loader.loadImage("yellow.png", Display.getDefault());
        sGreenImage = loader.loadImage("green.png", Display.getDefault());
        sNotSelectedImage = loader.loadImage("not-selected.png", Display.getDefault());
        sSelectedImage = loader.loadImage("selected.png", Display.getDefault());
        sFilteredImage = loader.loadImage("filtered.png", Display.getDefault());
        sFilteredSelectedImage = loader.loadImage("selected-filtered.png", Display.getDefault());
        this.mBoxColor = new Color((Device)Display.getDefault(), new RGB(225, 225, 225));
        this.mTextBackgroundColor = new Color((Device)Display.getDefault(), new RGB(82, 82, 82));
        if (this.mScaledSelectedImage != null) {
            this.mScaledSelectedImage.dispose();
        }
        sSystemFont = Display.getDefault().getSystemFont();
    }

    private void handleMouseDrag(DrawableViewNode.Point pt) {
        if (this.mDraggedNode != null) {
            if (this.mLastPoint.y - pt.y != 0.0) {
                this.mNodeMoved = true;
            }
            this.mDraggedNode.move(this.mLastPoint.y - pt.y);
            this.mLastPoint = pt;
            return;
        }
        double xDif = (this.mLastPoint.x - pt.x) / this.mZoom;
        double yDif = (this.mLastPoint.y - pt.y) / this.mZoom;
        double treeX = this.mTree.bounds.x - 220.0;
        double treeY = this.mTree.bounds.y - 220.0;
        double treeWidth = this.mTree.bounds.width + 440.0;
        double treeHeight = this.mTree.bounds.height + 440.0;
        if (this.mViewport.width > treeWidth) {
            if (xDif < 0.0 && this.mViewport.x + this.mViewport.width > treeX + treeWidth) {
                this.mViewport.x = Math.max(this.mViewport.x + xDif, treeX + treeWidth - this.mViewport.width);
            } else if (xDif > 0.0 && this.mViewport.x < treeX) {
                this.mViewport.x = Math.min(this.mViewport.x + xDif, treeX);
            }
        } else if (xDif < 0.0 && this.mViewport.x > treeX) {
            this.mViewport.x = Math.max(this.mViewport.x + xDif, treeX);
        } else if (xDif > 0.0 && this.mViewport.x + this.mViewport.width < treeX + treeWidth) {
            this.mViewport.x = Math.min(this.mViewport.x + xDif, treeX + treeWidth - this.mViewport.width);
        }
        if (this.mViewport.height > treeHeight) {
            if (yDif < 0.0 && this.mViewport.y + this.mViewport.height > treeY + treeHeight) {
                this.mViewport.y = Math.max(this.mViewport.y + yDif, treeY + treeHeight - this.mViewport.height);
            } else if (yDif > 0.0 && this.mViewport.y < treeY) {
                this.mViewport.y = Math.min(this.mViewport.y + yDif, treeY);
            }
        } else if (yDif < 0.0 && this.mViewport.y > treeY) {
            this.mViewport.y = Math.max(this.mViewport.y + yDif, treeY);
        } else if (yDif > 0.0 && this.mViewport.y + this.mViewport.height < treeY + treeHeight) {
            this.mViewport.y = Math.min(this.mViewport.y + yDif, treeY + treeHeight - this.mViewport.height);
        }
        this.mLastPoint = pt;
    }

    private DrawableViewNode.Point transformPoint(double x, double y) {
        float[] pt = new float[]{(float)x, (float)y};
        this.mInverse.transform(pt);
        return new DrawableViewNode.Point(pt[0], pt[1]);
    }

    private static void paintRecursive(GC gc, Transform transform, DrawableViewNode node, DrawableViewNode selectedNode, Path connectionPath) {
        if (selectedNode == node && node.viewNode.filtered) {
            gc.drawImage(sFilteredSelectedImage, node.left, (int)Math.round(node.top));
        } else if (selectedNode == node) {
            gc.drawImage(sSelectedImage, node.left, (int)Math.round(node.top));
        } else if (node.viewNode.filtered) {
            gc.drawImage(sFilteredImage, node.left, (int)Math.round(node.top));
        } else {
            gc.drawImage(sNotSelectedImage, node.left, (int)Math.round(node.top));
        }
        int fontHeight = gc.getFontMetrics().getHeight();
        int contentWidth = 162;
        String name = node.viewNode.name;
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            name = name.substring(dotIndex + 1);
        }
        double x = node.left + 9;
        double y = node.top + 8.0;
        TreeView.drawTextInArea(gc, transform, name, x, y, contentWidth, fontHeight, 10, true);
        TreeView.drawTextInArea(gc, transform, "@" + node.viewNode.hashCode, x, y += (double)(fontHeight + 3), contentWidth, fontHeight, 8, false);
        y += (double)(fontHeight + 3);
        if (!node.viewNode.id.equals("NO_ID")) {
            TreeView.drawTextInArea(gc, transform, node.viewNode.id, x, y, contentWidth, fontHeight, 8, false);
        }
        if (node.viewNode.measureRating != ViewNode.ProfileRating.NONE) {
            y = node.top + 100.0 - 8.0 - (double)TreeView.sRedImage.getBounds().height;
            x += (double)((contentWidth - (TreeView.sRedImage.getBounds().width * 3 + 6)) / 2);
            switch (node.viewNode.measureRating) {
                case GREEN: {
                    gc.drawImage(sGreenImage, (int)x, (int)y);
                    break;
                }
                case YELLOW: {
                    gc.drawImage(sYellowImage, (int)x, (int)y);
                    break;
                }
                case RED: {
                    gc.drawImage(sRedImage, (int)x, (int)y);
                }
            }
            x += (double)(TreeView.sRedImage.getBounds().width + 3);
            switch (node.viewNode.layoutRating) {
                case GREEN: {
                    gc.drawImage(sGreenImage, (int)x, (int)y);
                    break;
                }
                case YELLOW: {
                    gc.drawImage(sYellowImage, (int)x, (int)y);
                    break;
                }
                case RED: {
                    gc.drawImage(sRedImage, (int)x, (int)y);
                }
            }
            x += (double)(TreeView.sRedImage.getBounds().width + 3);
            switch (node.viewNode.drawRating) {
                case GREEN: {
                    gc.drawImage(sGreenImage, (int)x, (int)y);
                    break;
                }
                case YELLOW: {
                    gc.drawImage(sYellowImage, (int)x, (int)y);
                    break;
                }
                case RED: {
                    gc.drawImage(sRedImage, (int)x, (int)y);
                }
            }
        }
        Point indexExtent = gc.stringExtent(Integer.toString(node.viewNode.index));
        x = node.left + 180 - 7 - indexExtent.x;
        y = node.top + 100.0 - 7.0 - (double)indexExtent.y;
        gc.drawText(Integer.toString(node.viewNode.index), (int)x, (int)y, 1);
        int N = node.children.size();
        if (N == 0) {
            return;
        }
        float childSpacing = 80.0f / (float)N;
        for (int i = 0; i < N; ++i) {
            DrawableViewNode child = node.children.get(i);
            TreeView.paintRecursive(gc, transform, child, selectedNode, connectionPath);
            float x1 = node.left + 180;
            float y1 = (float)node.top + 10.0f + childSpacing * (float)i + childSpacing / 2.0f;
            float x2 = child.left;
            float y2 = (float)child.top + 50.0f;
            float cx1 = x1 + 17.5f;
            float cy1 = y1;
            float cx2 = x2 - 17.5f;
            float cy2 = y2;
            connectionPath.moveTo(x1, y1);
            connectionPath.cubicTo(cx1, cy1, cx2, cy2, x2, y2);
        }
    }

    private static void drawTextInArea(GC gc, Transform transform, String text, double x, double y, double width, double height, int fontSize, boolean bold) {
        Font oldFont = gc.getFont();
        Font newFont = TreeView.getFont(fontSize, bold);
        gc.setFont(newFont);
        Point extent = gc.stringExtent(text);
        if ((double)extent.x > width) {
            double scale = width / (double)extent.x;
            float[] transformElements = new float[6];
            transform.getElements(transformElements);
            transform.scale((float)scale, (float)scale);
            gc.setTransform(transform);
            y /= scale;
            gc.drawText(text, (int)(x /= scale), (int)(y += ((double)extent.y / scale - (double)extent.y) / 2.0), 1);
            transform.setElements(transformElements[0], transformElements[1], transformElements[2], transformElements[3], transformElements[4], transformElements[5]);
            gc.setTransform(transform);
        } else {
            gc.drawText(text, (int)(x + (width - (double)extent.x) / 2.0), (int)(y + (height - (double)extent.y) / 2.0), 1);
        }
        gc.setFont(oldFont);
        newFont.dispose();
    }

    public static Image paintToImage(DrawableViewNode tree) {
        Image image = new Image((Device)Display.getDefault(), (int)Math.ceil(tree.bounds.width), (int)Math.ceil(tree.bounds.height));
        Transform transform = new Transform((Device)Display.getDefault());
        transform.identity();
        transform.translate((float)(-tree.bounds.x), (float)(-tree.bounds.y));
        Path connectionPath = new Path((Device)Display.getDefault());
        GC gc = new GC((Drawable)image);
        Color white = new Color((Device)Display.getDefault(), 255, 255, 255);
        Color black = new Color((Device)Display.getDefault(), 0, 0, 0);
        gc.setForeground(white);
        gc.setBackground(black);
        gc.fillRectangle(0, 0, image.getBounds().width, image.getBounds().height);
        gc.setTransform(transform);
        TreeView.paintRecursive(gc, transform, tree, null, connectionPath);
        gc.drawPath(connectionPath);
        gc.dispose();
        connectionPath.dispose();
        white.dispose();
        black.dispose();
        return image;
    }

    private static Font getFont(int size, boolean bold) {
        FontData[] fontData = sSystemFont.getFontData();
        for (int i = 0; i < fontData.length; ++i) {
            fontData[i].setHeight(size);
            if (!bold) continue;
            fontData[i].setStyle(1);
        }
        return new Font((Device)Display.getDefault(), fontData);
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeView.this.redraw();
            }
        });
    }

    public void loadAllData() {
        boolean newViewport = this.mViewport == null;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                10 var1_1 = this;
                synchronized (var1_1) {
                    TreeView.this.mTree = TreeView.this.mModel.getTree();
                    TreeView.this.mSelectedNode = TreeView.this.mModel.getSelection();
                    TreeView.this.mViewport = TreeView.this.mModel.getViewport();
                    TreeView.this.mZoom = TreeView.this.mModel.getZoom();
                    if (TreeView.this.mTree != null && TreeView.this.mViewport == null) {
                        TreeView.this.mViewport = new DrawableViewNode.Rectangle(0.0, ((TreeView)TreeView.this).mTree.top + 50.0 - (double)(TreeView.this.getBounds().height / 2), TreeView.this.getBounds().width, TreeView.this.getBounds().height);
                    } else {
                        TreeView.this.setTransform();
                    }
                }
            }
        });
        if (newViewport) {
            this.mModel.setViewport(this.mViewport);
        }
    }

    @Override
    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                11 var1_1 = this;
                synchronized (var1_1) {
                    TreeView.this.mTree = TreeView.this.mModel.getTree();
                    TreeView.this.mSelectedNode = TreeView.this.mModel.getSelection();
                    if (TreeView.this.mTree == null) {
                        TreeView.this.mViewport = null;
                    } else {
                        TreeView.this.mViewport = new DrawableViewNode.Rectangle(0.0, ((TreeView)TreeView.this).mTree.top + 50.0 - (double)(TreeView.this.getBounds().height / 2), TreeView.this.getBounds().width, TreeView.this.getBounds().height);
                    }
                }
            }
        });
        if (this.mViewport != null) {
            this.mModel.setViewport(this.mViewport);
        } else {
            this.doRedraw();
        }
    }

    private void setTransform() {
        if (this.mViewport != null && this.mTree != null) {
            this.mTransform.identity();
            this.mInverse.identity();
            this.mTransform.scale((float)this.mZoom, (float)this.mZoom);
            this.mInverse.scale((float)this.mZoom, (float)this.mZoom);
            this.mTransform.translate((float)(-this.mViewport.x), (float)(-this.mViewport.y));
            this.mInverse.translate((float)(-this.mViewport.x), (float)(-this.mViewport.y));
            this.mInverse.invert();
        }
    }

    @Override
    public void viewportChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                12 var1_1 = this;
                synchronized (var1_1) {
                    TreeView.this.mViewport = TreeView.this.mModel.getViewport();
                    TreeView.this.mZoom = TreeView.this.mModel.getZoom();
                    TreeView.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    @Override
    public void zoomChanged() {
        this.viewportChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged() {
        TreeView treeView = this;
        synchronized (treeView) {
            this.mSelectedNode = this.mModel.getSelection();
            if (this.mSelectedNode != null && this.mSelectedNode.viewNode.image == null) {
                HierarchyViewerDirector.getDirector().loadCaptureInBackground(this.mSelectedNode.viewNode);
            }
        }
        this.doRedraw();
    }
}

