/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.values;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.values.NumberValue;
import com.google.clearsilver.jsilver.values.StringValue;
import com.google.clearsilver.jsilver.values.VariableValue;
import java.util.HashMap;
import java.util.Map;

public abstract class Value {
    private static final Map<EscapeMode, Value> EMPTY_PART_ESCAPED = new HashMap<EscapeMode, Value>(2);
    private static final Map<EscapeMode, Value> EMPTY_UNESCAPED;
    private static final Map<EscapeMode, Value> ZERO_PART_ESCAPED;
    private static final Map<EscapeMode, Value> ZERO_UNESCAPED;
    private static final Map<EscapeMode, Value> ONE_PART_ESCAPED;
    private static final Map<EscapeMode, Value> ONE_UNESCAPED;
    private final boolean partiallyEscaped;
    private final EscapeMode escapeMode;

    public Value(EscapeMode escapeMode, boolean partiallyEscaped) {
        this.escapeMode = escapeMode;
        this.partiallyEscaped = partiallyEscaped;
    }

    public abstract boolean asBoolean();

    public abstract String asString();

    public abstract int asNumber();

    public abstract boolean exists();

    public abstract boolean isEmpty();

    public static Value literalValue(int value, EscapeMode mode, boolean partiallyEscaped) {
        return Value.getIntValue(mode, partiallyEscaped, value);
    }

    public static Value literalValue(String value, EscapeMode mode, boolean partiallyEscaped) {
        Value v;
        if (value.isEmpty() && (v = (partiallyEscaped ? EMPTY_PART_ESCAPED : EMPTY_UNESCAPED).get((Object)mode)) != null) {
            return v;
        }
        return new StringValue(value, mode, partiallyEscaped);
    }

    public static Value literalValue(boolean value, EscapeMode mode, boolean partiallyEscaped) {
        return Value.getIntValue(mode, partiallyEscaped, value ? 1 : 0);
    }

    private static Value getIntValue(EscapeMode mode, boolean partiallyEscaped, int num) {
        Value v = null;
        if (num == 0) {
            v = (partiallyEscaped ? ZERO_PART_ESCAPED : ZERO_UNESCAPED).get((Object)mode);
        } else if (num == 1) {
            v = (partiallyEscaped ? ONE_PART_ESCAPED : ONE_UNESCAPED).get((Object)mode);
        }
        if (v != null) {
            return v;
        }
        return new NumberValue(num, mode, partiallyEscaped);
    }

    public static Value literalConstant(int value, Value ... inputs) {
        boolean isPartiallyEscaped = false;
        for (Value input : inputs) {
            if (!input.isPartiallyEscaped()) continue;
            isPartiallyEscaped = true;
            break;
        }
        return Value.literalValue(value, EscapeMode.ESCAPE_IS_CONSTANT, isPartiallyEscaped);
    }

    public static Value literalConstant(String value, Value ... inputs) {
        boolean isPartiallyEscaped = false;
        for (Value input : inputs) {
            if (!input.isPartiallyEscaped()) continue;
            isPartiallyEscaped = true;
            break;
        }
        return Value.literalValue(value, EscapeMode.ESCAPE_IS_CONSTANT, isPartiallyEscaped);
    }

    public static Value literalConstant(boolean value, Value ... inputs) {
        boolean isPartiallyEscaped = false;
        for (Value input : inputs) {
            if (!input.isPartiallyEscaped()) continue;
            isPartiallyEscaped = true;
            break;
        }
        return Value.literalValue(value, EscapeMode.ESCAPE_IS_CONSTANT, isPartiallyEscaped);
    }

    public static Value variableValue(String name, DataContext dataContext) {
        return new VariableValue(name, dataContext);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Value)) {
            return false;
        }
        Value otherValue = (Value)other;
        return this.exists() == otherValue.exists() && (this.asString().equals(otherValue.asString()) || this.isEmpty() && otherValue.isEmpty());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.asString();
    }

    public boolean isPartiallyEscaped() {
        return this.partiallyEscaped;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    static {
        EMPTY_PART_ESCAPED.put(EscapeMode.ESCAPE_NONE, new StringValue("", EscapeMode.ESCAPE_NONE, true));
        EMPTY_PART_ESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new StringValue("", EscapeMode.ESCAPE_IS_CONSTANT, true));
        EMPTY_UNESCAPED = new HashMap<EscapeMode, Value>(2);
        EMPTY_UNESCAPED.put(EscapeMode.ESCAPE_NONE, new StringValue("", EscapeMode.ESCAPE_NONE, false));
        EMPTY_UNESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new StringValue("", EscapeMode.ESCAPE_IS_CONSTANT, false));
        ZERO_PART_ESCAPED = new HashMap<EscapeMode, Value>(2);
        ZERO_PART_ESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(0, EscapeMode.ESCAPE_NONE, true));
        ZERO_PART_ESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(0, EscapeMode.ESCAPE_IS_CONSTANT, true));
        ZERO_UNESCAPED = new HashMap<EscapeMode, Value>(2);
        ZERO_UNESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(0, EscapeMode.ESCAPE_NONE, false));
        ZERO_UNESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(0, EscapeMode.ESCAPE_IS_CONSTANT, false));
        ONE_PART_ESCAPED = new HashMap<EscapeMode, Value>(2);
        ONE_PART_ESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(1, EscapeMode.ESCAPE_NONE, true));
        ONE_PART_ESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(1, EscapeMode.ESCAPE_IS_CONSTANT, true));
        ONE_UNESCAPED = new HashMap<EscapeMode, Value>(2);
        ONE_UNESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(1, EscapeMode.ESCAPE_NONE, false));
        ONE_UNESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(1, EscapeMode.ESCAPE_IS_CONSTANT, false));
    }
}

