/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.format;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.format.GLAPISpec;
import com.android.ide.eclipse.gltrace.format.GLDataTypeSpec;
import java.util.List;
import java.util.Map;

public class GLMessageFormatter {
    private static final String GL_NO_ERROR = "GL_NO_ERROR";
    private Map<String, GLAPISpec> mAPISpecs;

    public GLMessageFormatter(Map<String, GLAPISpec> specs) {
        this.mAPISpecs = specs;
    }

    public String formatGLMessage(GLProtoBuf.GLMessage glMessage) {
        GLAPISpec apiSpec = this.mAPISpecs.get(glMessage.getFunction().toString());
        if (apiSpec == null) {
            return glMessage.getFunction().toString();
        }
        return String.valueOf(this.formatCall(apiSpec, glMessage)) + this.formatReturnValue(apiSpec, glMessage);
    }

    private String formatReturnValue(GLAPISpec apiSpec, GLProtoBuf.GLMessage glMessage) {
        if (apiSpec.getReturnValue().getDataType() == GLProtoBuf.GLMessage.DataType.Type.VOID) {
            return "";
        }
        GLDataTypeSpec returnSpec = apiSpec.getReturnValue();
        return String.format(" = (%s) %s", returnSpec.getCType(), this.formatDataValue(glMessage.getReturnValue(), returnSpec, DataTypeContext.CONTEXT_RETURNVALUE));
    }

    private String formatCall(GLAPISpec apiSpec, GLProtoBuf.GLMessage glMessage) {
        return String.format("%s(%s)", apiSpec.getFunction(), this.formatArgs(glMessage, apiSpec.getArgs()));
    }

    private String formatArgs(GLProtoBuf.GLMessage glMessage, List<GLDataTypeSpec> argSpecs) {
        int sizeEstimate = 10 + argSpecs.size() * 5;
        StringBuilder sb = new StringBuilder(sizeEstimate);
        int i = 0;
        while (i < argSpecs.size()) {
            GLDataTypeSpec argSpec = argSpecs.get(i);
            if (argSpec.getDataType() == GLProtoBuf.GLMessage.DataType.Type.VOID && !argSpec.isPointer()) {
                sb.append("void");
            } else {
                sb.append(argSpec.getArgName());
                sb.append(" = ");
                sb.append(this.formatDataValue(glMessage.getArgs(i), argSpec, DataTypeContext.CONTEXT_ARGUMENT));
            }
            if (i < argSpecs.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private String formatDataValue(GLProtoBuf.GLMessage.DataType var, GLDataTypeSpec typeSpec, DataTypeContext context) {
        if (typeSpec.isPointer()) {
            return this.formatPointer(var, typeSpec.getDataType());
        }
        switch (typeSpec.getDataType()) {
            case VOID: {
                return "";
            }
            case BOOL: {
                return Boolean.toString(var.getBoolValue(0));
            }
            case FLOAT: {
                return String.format("%f", Float.valueOf(var.getFloatValue(0)));
            }
            case INT: {
                return Integer.toString(var.getIntValue(0));
            }
            case ENUM: {
                if (var.getIntValue(0) == 0 && context == DataTypeContext.CONTEXT_RETURNVALUE) {
                    return GL_NO_ERROR;
                }
                return GLEnum.valueOf(var.getIntValue(0)).toString();
            }
        }
        return "(unknown type)";
    }

    private String formatPointer(GLProtoBuf.GLMessage.DataType var, GLProtoBuf.GLMessage.DataType.Type typeSpec) {
        if (var.getType() != typeSpec && !this.isEnumTypeWithIntData(var, typeSpec)) {
            if (var.getIntValueCount() > 0) {
                return String.format("0x%x", var.getIntValue(0));
            }
            return "0x??";
        }
        switch (typeSpec) {
            case BOOL: {
                return var.getBoolValueList().toString();
            }
            case FLOAT: {
                return var.getFloatValueList().toString();
            }
            case INT: {
                return var.getIntValueList().toString();
            }
            case CHAR: {
                return var.getCharValueList().get(0).toStringUtf8();
            }
            case ENUM: {
                List<Integer> vals = var.getIntValueList();
                StringBuilder sb = new StringBuilder(vals.size() * 5);
                sb.append('[');
                for (Integer v : vals) {
                    sb.append((Object)GLEnum.valueOf(v.intValue()));
                }
                sb.append(']');
                return sb.toString();
            }
            case VOID: {
                if (var.getRawBytesList().size() > 0) {
                    return String.format("[ %d bytes ]", var.getRawBytesList().get(0).size());
                }
                return "[]";
            }
        }
        if (var.getIntValue(0) == 0) {
            return "NULL";
        }
        return String.format("0x%x", var.getIntValue(0));
    }

    private boolean isEnumTypeWithIntData(GLProtoBuf.GLMessage.DataType var, GLProtoBuf.GLMessage.DataType.Type typeSpec) {
        return var.getType() == GLProtoBuf.GLMessage.DataType.Type.INT && typeSpec == GLProtoBuf.GLMessage.DataType.Type.ENUM;
    }

    private static enum DataTypeContext {
        CONTEXT_ARGUMENT,
        CONTEXT_RETURNVALUE;

    }
}

