/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.HIThemeTrackDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.SliderTrackInfo;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ScaleDrawData
extends RangeDrawData {
    public int increment;
    public int pageIncrement;

    public ScaleDrawData() {
        this.state = new int[4];
    }

    HIThemeTrackDrawInfo getInfo() {
        int n = this.state[1];
        int n2 = this.state[2];
        int n3 = this.state[3];
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = new HIThemeTrackDrawInfo();
        hIThemeTrackDrawInfo.min = this.minimum;
        hIThemeTrackDrawInfo.max = Math.max(this.minimum, this.maximum);
        hIThemeTrackDrawInfo.value = this.selection;
        hIThemeTrackDrawInfo.kind = (short)2;
        hIThemeTrackDrawInfo.attributes = (short)4;
        if ((this.style & 0x100) != 0) {
            hIThemeTrackDrawInfo.attributes = (short)(hIThemeTrackDrawInfo.attributes | 1);
        }
        hIThemeTrackDrawInfo.enableState = (byte)3;
        if ((this.state[0] & 0x10) != 0) {
            hIThemeTrackDrawInfo.enableState = 0;
        }
        if ((this.state[0] & 0x20) != 0) {
            hIThemeTrackDrawInfo.enableState = 1;
        }
        hIThemeTrackDrawInfo.slider = new SliderTrackInfo();
        int n4 = 0;
        if ((n & 8) != 0) {
            n4 |= 2;
        }
        if ((n2 & 8) != 0) {
            n4 |= 0x20;
        }
        if ((n3 & 8) != 0) {
            n4 |= 8;
        }
        hIThemeTrackDrawInfo.slider.pressState = (byte)n4;
        return hIThemeTrackDrawInfo;
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        hIThemeTrackDrawInfo.bounds_x = rectangle.x;
        hIThemeTrackDrawInfo.bounds_y = rectangle.y;
        hIThemeTrackDrawInfo.bounds_width = rectangle.width;
        hIThemeTrackDrawInfo.bounds_height = rectangle.height;
        OS.HIThemeDrawTrack(hIThemeTrackDrawInfo, null, gC.handle, 0);
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = point.x;
        cGPoint.y = point.y;
        short[] sArray = new short[1];
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        if (OS.HIThemeHitTestTrack(hIThemeTrackDrawInfo, cGPoint, sArray)) {
            switch (sArray[0]) {
                case 22: {
                    return 1;
                }
                case 23: {
                    return 2;
                }
                case 129: {
                    return 3;
                }
            }
        }
        return -1;
    }
}

